% function hdgp credit to
% Bertille Antoine, Lynda Khalaf, Maral Kichian & Zhenjiang Lin (2022)
% Identification-robust inference with simulation-based pseudo-matching
% Journal of Business & Economic Statistics, DOI: 10.1080/07350015.2021.2019046

%matrix representation
function [PSI_0, PSI_1, PHI_1, PHI_epsilon]=hdgp(zeta_p)
        % Set Parameter Values (The true DGP):
% --------------------------------------------------------------------
% these values are calibrated
beta = 0.98; %Discount rate
gamma=1.005;% the growth rate of technology
lambda=0.15;
pistar=1.005;%
nu = 0;
%zeta_p=0.65; 
%zeta_p=CALI;
rho_lambda=0.88; % miscalibration on rho_lambda
%*****************************
MIS=[0.7 0.95];
rho_z=0.13;
sigma_phi=3;
sigma_lambda=0.5;
sigma_z=1.5;
rho_phi=0.3; %
sigma_R=1;
kappa_p=(1-zeta_p*beta)*(1-zeta_p)/zeta_p;
psi_p=1/(1+kappa_p/beta*(1+nu));
% Solution
PSI_0=ones(4,1);
x_phi=-(kappa_p*psi_p/beta)/(1-psi_p*rho_phi);
x_lambda=-(kappa_p*psi_p/beta)/(1-psi_p*rho_lambda);
x_z=(rho_z*psi_p)/(1-psi_p*rho_z);
x_epsilonR=-psi_p*sigma_R;
PSI_1=zeros(4,5);
PHI_1=zeros(4,5);
PHI_epsilon=zeros(5,4);

PSI_1(1,1)=x_phi;
PSI_1(1,2)=x_lambda;
PSI_1(1,3)=x_z + 1;
PSI_1(1,4)=x_epsilonR;
PSI_1(1,5)=-1;
PSI_1(2,1)=1+(1+nu)*x_phi;
PSI_1(2,2)=(1+nu)*x_lambda;
PSI_1(2,3)=(1+nu)*x_z;
PSI_1(2,4)=(1+nu)*x_epsilonR;
PSI_1(2,5)=0;
PSI_1(3,1)=(kappa_p/(1-beta*rho_phi))*(1+(1+nu)*x_phi);
PSI_1(3,2)=(kappa_p/(1-beta*rho_lambda))*(1+(1+nu)*x_lambda);
PSI_1(3,3)=(kappa_p/(1-beta*rho_z))*(1+nu)*x_z;
PSI_1(3,4)=kappa_p*(1+nu)*x_epsilonR;
PSI_1(3,5)=0;
PSI_1(4,1)=((kappa_p/beta)/(1-beta*rho_phi))*(1+(1+nu)*x_phi);
PSI_1(4,2)=((kappa_p/beta)/(1-beta*rho_lambda))*(1+(1+nu)*x_lambda);
PSI_1(4,3)=((kappa_p/beta)/(1-beta*rho_z))*(1+nu)*x_z;
PSI_1(4,4)=kappa_p*(1+nu)*x_epsilonR/beta+sigma_R;
PSI_1(4,5)=0;

PHI_1(1,1)=rho_phi;
PHI_1(1,2)=0;
PHI_1(1,3)=0;
PHI_1(1,4)=0;
PHI_1(1,5)=0;
PHI_1(2,1)=0;
PHI_1(2,2)=rho_lambda;
PHI_1(2,3)=0;
PHI_1(2,4)=0;
PHI_1(2,5)=0;
PHI_1(3,1)=0;
PHI_1(3,2)=0;
PHI_1(3,3)=rho_z;
PHI_1(3,4)=0;
PHI_1(3,5)=0;
PHI_1(4,1)=0;
PHI_1(4,2)=0;
PHI_1(4,3)=0;
PHI_1(4,4)=0;
PHI_1(4,5)=0;
PHI_1(5,1)=x_phi;
PHI_1(5,2)=x_lambda;
PHI_1(5,3)=x_z;
PHI_1(5,4)=x_epsilonR;
PHI_1(5,5)=0;

PHI_epsilon(1,1)=sigma_phi;
PHI_epsilon(1,2)=0;
PHI_epsilon(1,3)=0;
PHI_epsilon(1,4)=0;
PHI_epsilon(2,1)=0;
PHI_epsilon(2,2)=sigma_lambda;
PHI_epsilon(2,3)=0;
PHI_epsilon(2,4)=0;
PHI_epsilon(3,1)=0;
PHI_epsilon(3,2)=0;
PHI_epsilon(3,3)=sigma_z;
PHI_epsilon(3,4)=0;
PHI_epsilon(4,1)=0;
PHI_epsilon(4,2)=0;
PHI_epsilon(4,3)=0;
PHI_epsilon(4,4)=1;
PHI_epsilon(5,1)=0;
PHI_epsilon(5,2)=0;
PHI_epsilon(5,3)=0;
PHI_epsilon(5,4)=0;